define(['angular', 'angularMocks', 'NotificationSettingsController', 'NotificationsConstants', 'angularUiBootstrap', 'lodash'], function(angular, mocks) {
	'use strict';

	describe("The Notification Settings controller", function () {
		var controller, 
			scope,
			q,
			focusServiceMock,
			modalServiceMock,
			notificationsPreferencesServiceMock,
			notificationsInstanceBuilderServiceMock,
			windowMock = window,
			isUserOptedIn = true,
			fakeModal = {
				result: {
					then: function() {}
				},
				close: function() {},
				dismiss: function() {}
			};

		beforeEach( function () {
			module('angularTemplateApp');

			focusServiceMock = jasmine.createSpyObj('focusService', ['focusElement', 'focusTopModal']);
			modalServiceMock = jasmine.createSpyObj('modalService', ['showModal']);
			notificationsInstanceBuilderServiceMock = jasmine.createSpyObj('NotificationsInstanceBuilderService', ['instance', 'hasLiveInstance']);
			notificationsPreferencesServiceMock = jasmine.createSpyObj('NotificationsPreferencesService', ['getNotificationsPreference', 'getPreferencesData', 'updateNotificationsPreference', 'updatePreferencesData']);
			notificationsPreferencesServiceMock.getPreferencesData.and.returnValue({then: function () {}});
			notificationsPreferencesServiceMock.getNotificationsPreference.and.returnValue({then: function () {}});

			module(function($provide){
				$provide.value('focusService', focusServiceMock);
				$provide.value('modalService', modalServiceMock);
				$provide.value('NotificationsPreferencesService', notificationsPreferencesServiceMock);
				$provide.value('NotificationsInstanceBuilderService', notificationsInstanceBuilderServiceMock);
			});

			inject(function($controller, $rootScope, $modal, $q, NotificationsConstants) {
				scope = $rootScope.$new();
				q = $q;
				controller = $controller('NotificationSettingsController', { $scope:scope, $modalInstance:fakeModal, isUserOptedIn: isUserOptedIn, NotificationsConstants: NotificationsConstants });
			});

			inject(function($modal) {
				spyOn($modal, 'open').and.returnValue(fakeModal);
				spyOn(fakeModal, 'close');
				spyOn(fakeModal, 'dismiss');
			});
		});

		it ("should have scope values initialized", function () {
			expect(scope.timeZoneOptions).toEqual([ '(+00:00) WET (Western European Time)', '(+01:00) CET (Central European Time)', '(+02:00) EET (Eastern European Time)', '(+04:00) Europe/Moscow', '(+04:00) Asia/Dubai', '(+04:30) Asia/Kabul', '(+05:00) Asia/Aqtau', '(+05:00) Asia/Aqtobe', '(+05:45) Asia/Kathmandu', '(+06:00) Asia/Almaty', '(+06:30) Asia/Rangoon', '(+07:00) Asia/Bangkok', '(+07:00) Asia/Jakarta', '(+08:00) Asia/Singapore', '(+09:00) Asia/Jayapura', '(+09:00) Asia/Tokyo', '(+11:00) Asia/Sakhalin', '(+10:00) Australia/Sydney', '(+12:00) Asia/Anadyr', '(+12:00) Antarctica/McMurdo', '(+12:00) Pacific/Fiji', '(+13:00) Pacific/Enderbury', '(+14:00) Pacific/Kiritimati', '(-01:00) Atlantic/Cape_Verde', '(-01:00) America/Scoresbysund', '(-03:00) America/Argentina/San_Juan', '(-04:00) America/Argentina/San_Luis', '(-05:00) America/New_York (Eastern)', '(-06:00) America/Chicago (Central)', '(-07:00) America/Denver (Mountain)', '(-08:00) America/Los_Angeles (Pacific)', '(-09:00) America/Juneau', '(-10:00) Pacific/Honolulu', '(-11:00) Pacific/Midway', '(+00:00) Etc/GMT+12' ]);
			expect(scope.optInOptions).toEqual(["Yes", "No"]);
			expect(scope.preferences).toEqual({ optInSelected: null, emailAddress : null, timeZone: null });
		});

		describe("when Learn more link is clicked", function () {
			beforeEach(function () {
				spyOn(windowMock, 'open');
				scope.showUserGuide();
			});

			it ("should open a new browser window to the notification section of the user guide", function() {
				expect(windowMock.open).toHaveBeenCalledWith('src/ui-components/modals/help/guide/guide.html#/features/notifications', '_blank', 'location=no,scrollbars=1,resizable=1');
			});
		});
		
		describe("when save is clicked and opting out", function () {
			beforeEach(function () {
				scope.preferences.optInSelected = "No";

				var modalPromise = q.defer();
				modalPromise.resolve({});

				scope.settingsForm = {
					validationSummary: {
						validate: function () { return modalPromise.promise; }
					}
				};
				var deferred = q.defer();
				deferred.resolve('resolvedData');
				notificationsPreferencesServiceMock.updateNotificationsPreference.and.returnValue(deferred.promise);
				scope.save();
				scope.$apply();
			});

			it ("should request to create or update a time zone preference", function() {
				expect(notificationsPreferencesServiceMock.updatePreferencesData).toHaveBeenCalled();
			});

			it("should send a request to opt the user out", function () {
				expect(notificationsPreferencesServiceMock.updateNotificationsPreference).toHaveBeenCalledWith(false);
			});

			it ("should close the modal", function() {
				expect(fakeModal.close).toHaveBeenCalled();
			});
		});

		describe("when save is clicked and opting in without selecting a time zone", function () {
			beforeEach(function () {
				scope.preferences.optInSelected = "Yes";
				scope.preferences.timeZone = null;

				var modalPromise = q.defer();
				modalPromise.reject({});
				scope.settingsForm = {
					validationSummary: {
						validate: function () { return modalPromise.promise; }
					}
				};
				var deferred = q.defer();
				deferred.resolve('resolvedData');
				notificationsPreferencesServiceMock.updateNotificationsPreference.and.returnValue(deferred.promise);
				scope.save();
				scope.$apply();
			});

			it ("should not request to create or update a time zone preference", function() {
				expect(notificationsPreferencesServiceMock.updatePreferencesData).not.toHaveBeenCalled();
			});

			it("should send a request to opt the user out", function () {
				expect(notificationsPreferencesServiceMock.updateNotificationsPreference).not.toHaveBeenCalled();
			});

			it ("should not close the modal", function() {
				expect(fakeModal.close).not.toHaveBeenCalled();
			});
		});

		describe("when save is clicked and opting in and selecting a time zone (create)", function () {
			beforeEach(function () {
				scope.preferences.optInSelected = "Yes";
				scope.preferences.timeZone = "(-05:00) America/New_York (Eastern)";
				
				var modalPromise = q.defer();
				modalPromise.resolve({});
				scope.settingsForm = {
					validationSummary: {
						validate: function () { return modalPromise.promise; }
					}
				};
				var deferred = q.defer();
				deferred.resolve('resolvedData');
				notificationsPreferencesServiceMock.updateNotificationsPreference.and.returnValue(deferred.promise);
				scope.save();
				scope.$apply();
			});

			it ("should create a time zone preference", function() {
				expect(notificationsPreferencesServiceMock.updatePreferencesData).toHaveBeenCalledWith(null, "(-05:00) America/New_York (Eastern)");
			});

			it("should send a request to opt the user out", function () {
				expect(notificationsPreferencesServiceMock.updateNotificationsPreference).toHaveBeenCalledWith(true);
			});

			it ("should close the modal", function() {
				expect(fakeModal.close).toHaveBeenCalled();
			});
		});

		describe("when save is clicked and opting in and selecting a time zone (update)", function () {
			beforeEach(function () {
				scope.preferences.optInSelected = "Yes";
				scope.preferences.timeZone = "(-05:00) America/New_York (Eastern)";
				scope.isTimeZoneStored = true;

				var modalPromise = q.defer();
				modalPromise.resolve({});

				scope.settingsForm = {
					validationSummary: {
						validate: function () { return modalPromise.promise; }
					}
				};
				var deferred = q.defer();
				deferred.resolve('resolvedData');
				notificationsPreferencesServiceMock.updateNotificationsPreference.and.returnValue(deferred.promise);
				scope.save();
				scope.$apply();
			});

			it ("should create a time zone preference", function() {
				expect(notificationsPreferencesServiceMock.updatePreferencesData).toHaveBeenCalledWith(null, "(-05:00) America/New_York (Eastern)");
			});

			it("should send a request to opt the user out", function () {
				expect(notificationsPreferencesServiceMock.updateNotificationsPreference).toHaveBeenCalledWith(true);
			});

			it ("should close the modal", function() {
				expect(fakeModal.close).toHaveBeenCalled();
			});
		});

		describe("when the Cancel button is clicked", function (){
			beforeEach( function () {
				scope.cancel();
			});

			it ("should dismiss the modal", function() {
				expect(fakeModal.dismiss).toHaveBeenCalled();
			});
		});
	});
});